/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.core.util.SourcePrinter;
import com.aptana.sax.ISchemaElement;
import com.aptana.sax.Messages;
import com.aptana.sax.Schema;
import com.aptana.sax.SchemaFreeformElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaElement
implements ISchemaElement {
    private String _name;
    private Schema _owningSchema;
    private Map<String, ISchemaElement> _transitions;
    private Map<String, Integer> _attributes;
    private List<String> _requiredAttributes;
    private boolean _allowFreeformMarkup;
    private String _instanceAttributes;
    private boolean _hasText;

    public SchemaElement(Schema owningSchema, String name) {
        if (owningSchema == null) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Owning_Schema);
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Name);
        }
        this._owningSchema = owningSchema;
        this._name = name;
        this._transitions = new HashMap<String, ISchemaElement>();
        this._attributes = new HashMap<String, Integer>();
        this._requiredAttributes = new ArrayList<String>();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addAttribute(String name, String usage) {
        int usageValue;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Name);
        }
        if (this.hasAttribute(name)) {
            String msg = MessageFormat.format(Messages.SchemaElement_Attribute_already_defined, name, this._name);
            throw new IllegalArgumentException(msg);
        }
        if (usage != null) {
            if (usage.equals("required")) {
                usageValue = 1;
            } else {
                if (!usage.equals("optional")) {
                    String msg = MessageFormat.format(Messages.SchemaElement_Not_valid_usage_attribute, usage);
                    throw new IllegalArgumentException(msg);
                }
                usageValue = 2;
            }
        } else {
            usageValue = 1;
        }
        this._attributes.put(name, usageValue);
        if ((usageValue & 3) == 1) {
            this._requiredAttributes.add(name);
        }
    }

    public void addTransition(ISchemaElement node) {
        if (node == null) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Node);
        }
        String nodeName = node.getName();
        if (this._transitions.containsKey(nodeName)) {
            String msg = "A node name '" + nodeName + "' has already been added to " + this._name;
            throw new IllegalArgumentException(msg);
        }
        this._transitions.put(nodeName, node);
    }

    public boolean allowFreeformMarkup() {
        return this._allowFreeformMarkup;
    }

    public String getName() {
        return this._name;
    }

    public Schema getOwningSchema() {
        return this._owningSchema;
    }

    public SchemaElement[] getTransitionElements() {
        Collection<ISchemaElement> values = this._transitions.values();
        return values.toArray(new SchemaElement[values.size()]);
    }

    public boolean hasAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public boolean hasText() {
        return this._hasText;
    }

    public boolean hasTransitions() {
        return this._transitions.size() > 0;
    }

    public boolean isDeprecatedAttribute(String name) {
        boolean result = false;
        if (this.isValidAttribute(name)) {
            int flags = this._attributes.get(name);
            result = (flags & 4) == 4;
        }
        return result;
    }

    public boolean isOptionalAttribute(String name) {
        boolean result = false;
        if (this.isValidAttribute(name)) {
            int flags = this._attributes.get(name);
            result = (flags & 3) == 2;
        }
        return result;
    }

    public boolean isRequiredAttribute(String name) {
        boolean result = false;
        if (this.isValidAttribute(name)) {
            int flags = this._attributes.get(name);
            result = (flags & 3) == 1;
        }
        return result;
    }

    public boolean isValidAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public boolean isValidTransition(String name) {
        return this._transitions.containsKey(name) || this.allowFreeformMarkup() || this.getOwningSchema().allowFreeformMarkup();
    }

    public ISchemaElement moveTo(String name) {
        ISchemaElement result = this._transitions.get(name);
        if (result == null && (this.allowFreeformMarkup() || this.getOwningSchema().allowFreeformMarkup())) {
            result = new SchemaFreeformElement(this.getOwningSchema());
        }
        return result;
    }

    public void setAllowFreeformMarkup(boolean value) {
        this._allowFreeformMarkup = value;
    }

    public void setHasText(boolean value) {
        this._hasText = value;
    }

    public String toString() {
        String result = "<" + this._name;
        if (this._instanceAttributes != null) {
            result = String.valueOf(result) + this._instanceAttributes;
        }
        result = this.hasTransitions() ? String.valueOf(result) + ">" : String.valueOf(result) + "/>";
        return result;
    }

    public void validateAttributes(Attributes attributes) throws SAXException {
        SourcePrinter writer;
        if (attributes.getLength() > 0) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < attributes.getLength()) {
                String key = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                buffer.append(' ').append(key).append("=\"").append(value).append('\"');
                ++i;
            }
            this._instanceAttributes = buffer.toString();
        }
        int i = 0;
        while (i < this._requiredAttributes.size()) {
            String name = this._requiredAttributes.get(i);
            String value = attributes.getValue(name);
            if (value == null) {
                writer = new SourcePrinter();
                writer.print('<').print(this._name).print("> requires a '").print(name).println("' attribute");
                this.getOwningSchema().buildErrorMessage(writer, this._name, attributes);
                throw new SAXException(writer.toString());
            }
            ++i;
        }
        i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            if (!this._attributes.containsKey(name)) {
                String message = MessageFormat.format(Messages.SchemaElement_Invalid_attribute_on_tag, name, this._name);
                writer = new SourcePrinter();
                writer.println(message);
                this.getOwningSchema().buildErrorMessage(writer, this._name, attributes);
                throw new SAXException(writer.toString());
            }
            ++i;
        }
    }
}

